//  
//  GLSPlayerVars.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Collections;
using UTILS;
using System.Text;
using System.Threading;

namespace LFSLapper
{
    partial class LFSClient
    {
        enum playerVars
        {
            NickName,               // nickName of the player
            NickNameStripped,       // nickName without color code
            UserName,               // User Name or LFS Name
            Car,                    // CUrrent car for the player
            PitWork,                // Work do on car on the pit
            PlayerFlags,            // Current players control flags
            PosAbs,                 // Current pos in top in format pos/total
            GroupQual,              // Current Group qualification if user is in the group qualification -> A,B,C,...
            PosQual,                // Current pos in qualification in format pos/total
            UnitSpeed,              // km/h or mph relative t o the player choice
            UnitDist,               // miles or kms relative t o the player choice
            Typ,                    // Spb type "PB" server, "Sess" Session, "WR" Worls record
            Dist,                   // dist for the player in km on this server
            SessDist,               // dist for the player in km on this session
            UNameBehind,            // UserName of the player behind you in race
            GapBehind,              // Gap between you and player behin in Race
            UNameBefore,            // the username of the player before you in race
            GapBefore,              // gap between you and the player before you in race
            OldTyreRearLeft,        // Old Tyre on rear left before pit
            OldTyreRearRight,       // Old Tyre on rear right before pit
            OldTyreFrontLeft,       // Old Tyre on front left before pit
            OldTyreFrontRight,      // Old Tyre on front right before pit
            TyreRearLeft,           // Current Tyre on rear left
            TyreRearRight,          // Current Tyre on rear right
            TyreFrontLeft,          // Current Tyre on front left
            TyreFrontRight,         // Current Tyre on front right
            AuthLevel,              // Player authorization level
            PenaltyNew,             // Player penalty new
            NumCarResets,           // Number of Car reset
            Laps,                   // Total number of laps done on the current track and with the current car
            Pos,                    // current position of the player in top
            SessLaps,               // Total number of laps done this session on current track and with the current car
            TotalPitTime,           // Cumuled Time used for a pit stop on session
            PitTime,                // Time used in Pit
            PitStops,               // Number of pitstop do by a player in session
            SwearWordsRem,          // Remaining number of swearwords to be used before OnSwearWords2 is triggered
            LapsDone,               // Total laps done for player current car/track
            P_Mass,                 // Current player Mass
            P_Tres,                 // Current Player  Restriction
            H_Mass,                 // Current Required Handicap User mass   
            H_Tres,                 // Current Required Handicap Restriction
            Split1,                 // Last First Split, updated when doing new Split1
            Split2,                 // Last Second Split, erased when doing Split1
            Split3,                 // Last third Split, erased when doing Split1
            LapTime,                // Current Lap Time, erased when doing New LapTime
            PBLapTime,              // Current PB on current Combo
            DiffLapTimeToPB,        // Laptime - PBLTime, Last PBLTime is new realised
            SplitTime,              // Last Split time done by player
            WR,                     // World record for this player Combo
			PBDrift,	            // Current Drift PB on current Combo
			PSDistance,				// online statistics of one racer - distance in metres
			PSFuel,					// online statistics of one racer - fuel burnt in cl
			PSLaps,					// online statistics of one racer - laps
			PSHostsJoined,			// online statistics of one racer - hosts joined
			PSWins,					// online statistics of one racer - Wins
			PSSecond,				// online statistics of one racer - Second
			PSThird,				// online statistics of one racer - third
			PSFinished,				// online statistics of one racer - finished
			PSQuals,				// online statistics of one racer - quals
			PSPole,					// online statistics of one racer - pole
			PSDrags,				// online statistics of one racer - drags
			PSDragWins,				// online statistics of one racer - drag wins
			PSCountry,				// online statistics of one racer - country


			Sector,           // Number of the current sector that the racer is in
			LastSector,           // Number of the last sector that the racer was in
			SectorSplit1,           // Last First sector Time, updated when doing new Split1
            SectorSplit2,           // Last Second sector Time, updated when doing new Split2
            SectorSplit3,           // Last third sector Time, updated when doing new Split3
            SectorSplitLast,        // Last Last sector Time, erased when doing Split1
            BestSectorSplit1,       // Best Split duration for the sector 1
            BestSectorSplit2,       // Best Split duration for the sector 2
            BestSectorSplit3,       // Best Split duration for the sector 3
            BestSectorSplitLast,    // BestSplit duration for the last sector
            DiffSectorSplit1,       // SectorSplit1 - BestSectorSplit1
            DiffSectorSplit2,       // SectorSplit2 - BestSectorSplit2
            DiffSectorSplit3,       // SectorSplit3 - BestSectorSplit3
            DiffSectorSplitLast,    // SectorSplitLast - BestSectorSplitLast
            IsBestSectorSplit1,     // 1 if this sector split is best than previous Best, otherwise 0
            IsBestSectorSplit2,     // 1 if this sector split is best than previous Best, otherwise 0
            IsBestSectorSplit3,     // 1 if this sector split is best than previous Best, otherwise 0
            IsBestSectorSplitLast,  // 1 if this sector split is best than previous Best, otherwise 0
            AvgSpeed,               // Avg Speed on last Lap Time
            InstantSpeed,           // Instant speed for the player
            BestSpeed,              // Best Speed done on this combo by player
            Tpb,                    // Theoretical PB using best sector split
            DriftScore,             // last Drift score
            AngleVelocity,          // Last Angle velocity in degrees
            LastDriftScore,         // Last drift score
            AccelerationStartSpeed,  // Min value for the acceleration feature relative to user unit km or mph
            AccelerationStartSpeed2, // Min value for the acceleration2 feature relative to user unit km or mph
            AccelerationEndSpeed,    // Max value for the acceleration feature relative to user unit km or mph
            AccelerationEndSpeed2,   // Max value for the acceleration2 feature relative to user unit km or mph
            AccelerationTime,        // Acceleration time achieved from start to end speed
            AccelerationTime2,       // Acceleration2 time achieved from start to end speed
            MaxAllowedLapTime1,     // Max Allowed Time before trigger Event OnMaxAllowedLapTime1
            MaxAllowedLapTime2,     // Max Allowed Time before trigger Event OnMaxAllowedLapTime2
            RemainFDIP,             // Remain count for fast drive in pit
            FinishedPos,            // finish or qualify pos (1 = win / 256 = not added to table)
            RaceTotalTime,          // race time (ms) the use of NumToMsh is needed
            RacePBTime,             // race personnal best time in ms the use of NumToMsh is needed
            CurrNode,               // is the node on the track where the player is, -1 is player is not on track
            OnTrack,                // 1 if player is on track, otherwise 0
            X,                      // Coordonate X axis of the player on the map
            Y,                      // Coordonate Y axis of the player on the map
            Z,                      // Coordonate Z axis of the player on the map
            IdZone,					// Id of the player zone where the player is
			TotDistMeter,			// Session distance in meter done by a player
			ViewSPBSplit,			// What split PB to Show, S = Session, P = PB, W = World record
			ShowSplitPb,			// Does the split PB iare showed 1 = Yes, 0 = No
			UnitSpeedKmh,			// What's unit is used for speed and distance 1 = km 0 = miles
			IdLang,					// Id of the player lang
			UCID,
			PLID,
			IsHost,
			NumberPlate,
            Heading,
            Direction,
            //Object Hit 
            ObjectContactSpeed,     //Speed of player when hitting a object
            ObjectContactHead,      //Heading of player when hitting a object
            ObjectContactDir,       //Direction of player when hitting a object
            //Extra Info for host (NCI Packet)
            IPAddress,           // Converted IP Adress from decimal number (See NCI Packet in insim4.cs)
            DecimalIPAddress,    // Decimal IP Adress straight from NCI Packet (See NCI Packet in insim4.cs)
            LFS_Language,       // Player Selected Langauge in LFS (See NCI Packet in insim4.cs)
            LFS_UserID,         // Unique LFSUserID (See NCI Packet in insim4.cs)
            //DefineStreet
            CurrStreet,
            idCurrStreet,
        }

        public void SetVarPlayer(GLScript.unionVal val, string idVar, string userName, string value)
        {
            infoPlayer currInfoPlayer = null;
            if (userName != "")
                currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);
            if (currInfoPlayer != null)
            {
                if (modifyBuitlPlayerVar( idVar, userName, value) == false)
                    currInfoPlayer.playerVars.Set(idVar, new GLScript.unionVal(0, utils.quote(value), GLScript.typVal.str));
                
            }
            val.typVal = GLScript.typVal.str;
			val.sval = utils.quote(value);
        }
        public bool modifyBuitlPlayerVar(string idVar, string userName, string value)
        {
            infoPlayer currInfoPlayer = null;
            if (userName != "")
                currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);
            if (currInfoPlayer != null)
            {
                switch (UTILS.utils.unquote(idVar).ToLower())
                {
                    // Player vars
					case "idlang": // Lang of the player
						try
						{
							currInfoPlayer.idLang = value.ToLower();
						}
						catch
						{
						}
						return true;
					case "viewspbsplit": // Typ of PB viewed (S)ession, (P)B server, (W)Record
						try
						{
							currInfoPlayer.viewSPBSplit = value;
						}
						catch
						{
						}
						return true;
					case "showsplitpb": // Is split is displayed
						try
						{
							if (int.Parse(value) == 1)
								currInfoPlayer.showSplitPB = true;
							else
								currInfoPlayer.showSplitPB = false;
						}
						catch
						{
						}
						return true;
					case "unitspeedkmh": // Unit of player distance 1 = km, 0 = mile
						try
						{
							if (int.Parse(value) == 1)
								currInfoPlayer.unitSpeedKmh = true;
							else
								currInfoPlayer.unitSpeedKmh = false;
						}
						catch
						{
						}
						return true;
					case "totdistmeter": // Player required Mass
						try
						{
							currInfoPlayer.totDistMeter = int.Parse(value);
							currInfoPlayer.lastTotDistMeter = currInfoPlayer.totDistMeter;
						}
						catch
						{
						}
						return true;
					case "h_mass": // Player required Mass
						try
						{
							currInfoPlayer.H_Mass = int.Parse(value);
						}
						catch
						{
							currInfoPlayer.H_Mass = 0;
						}
						playerHandicap[currInfoPlayer.userName] = new infoHandicap(currInfoPlayer.H_Mass, currInfoPlayer.H_TRes);
						return true;
					case "h_tres": // Player required Mass
                        try
                        {
                            currInfoPlayer.H_TRes = int.Parse(value);
                        }
                        catch
                        {
                            currInfoPlayer.H_TRes = 0;
                        }
                        playerHandicap[currInfoPlayer.userName] = new infoHandicap(currInfoPlayer.H_Mass, currInfoPlayer.H_TRes);
                        return true;
                    default:
                        return false;
                }
            }
            return false;
         }

        // CallBack For set a player value with a var in GLScrip
        public GLScript.unionVal CBset(string id, GLScript.unionVal val, string userName)
        {
            GLScript.unionVal uval = new GLScript.unionVal(0, utils.quote(""), GLScript.typVal.str);
            string value = "";
            if (val.typVal == GLScript.typVal.str)
                value = UTILS.utils.unquote(val.sval);
            else
                value = val.fval.ToString();

            if (modifyBuitlPlayerVar( id, userName, value) == false)
                myDebug.WriteLine("err", "Warning var " + id + " is readonly");
            
            return CBget(id, userName);
        }
        // CallBack For Get a player value with a var in GLScript
        public GLScript.unionVal CBget(string id, string userName)
        {
			GLScript.unionVal uval = new GLScript.unionVal(0, utils.quote(""), GLScript.typVal.str);
            GetVarPlayer(uval, UTILS.utils.unquote(id), userName);
            return uval;
        }
        void createPlayerSetOfVars(infoPlayer currInfoPlayer) // Called when a player is connectect
        {
            GLScript.SetOfVars sv = new GLScript.SetOfVars( );
            currInfoPlayer.playerVars = sv;

            foreach (string str in Enum.GetNames(typeof(playerVars)))
            {
				sv.Set(utils.quote(str), new GLScript.unionVal(0, "", GLScript.typVal.str, CBset,  CBget, currInfoPlayer.userName));
            }
        }

        public void GetVarPlayer(GLScript.unionVal val, string idVar, string userName)
        {
            infoPlayer currInfoPlayer = null;
            if (userName != "")
                currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);

            #region Var currInfoPlayer
            if (currInfoPlayer == null)
            {
                val.typVal = GLScript.typVal.str;
				val.sval = utils.quote("");
                return;
            }
            else
            {
                switch (idVar.ToLower())
                {
                    // AlphaNumeric return
					case "nickname":
                        val.typVal = GLScript.typVal.str;
                        val.sval = utils.quote(currInfoPlayer.nickName);
                        break;
                    case "nicknamestripped":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(UTILS.utils.stripLFSColor(currInfoPlayer.nickName));
                        break;
                    case "username":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.userName);
                        break;
                    case "car":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.CName);
                        break;
                    case "pitwork":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.pitWork);
                        break;
                    case "playerflags":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.sPlayerFlags);
                        break;

                    //Extra Info for Host (NCI Insimpacket)
                    case "lfs_language":
                        val.typVal = GLScript.typVal.str;
                        val.sval = utils.quote(currInfoPlayer.LFS_Language);
                        break;
                    case "lfs_userid":
                        val.typVal = GLScript.typVal.str;
                        val.sval = "\"" + currInfoPlayer.LFS_UserID + "\"";
                        break;
                    case "decimalipaddress":
                        val.typVal = GLScript.typVal.str;
                        val.sval = "\"" + currInfoPlayer.DecimalIPAddress + "\"";
                        break;
                    case "ipaddress":
                        val.typVal = GLScript.typVal.str;
                        val.sval = utils.quote(currInfoPlayer.IPAddress);
                        break;
                    //Extra Info for Host (NCI Insimpacket)
                    case "posabs":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, false);
                            if (tmpPosQualUser.posUser != 0)
								val.sval = utils.quote(tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                            else
								val.sval = utils.quote("-/-");
                        }
                        break;
                    case "groupqual":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, true);
                            if (tmpPosQualUser.groupUser != -1)
								val.sval = utils.quote(((char)(tmpPosQualUser.groupUser + 65)).ToString());
                            else
								val.sval = utils.quote("-");
                        }
                        break;
                    case "posqual":
                        {
                            val.typVal = GLScript.typVal.str;
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.userName, true);
                            if (tmpPosQualUser.posUser != 0)
								val.sval = utils.quote(tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                            else
								val.sval = utils.quote("-/-");
                        }
                        break;
                    case "unitspeed":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(getUnitSpeed(currInfoPlayer.unitSpeedKmh));
                        break;
                    case "unitdist":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(getUnitDist(currInfoPlayer.unitSpeedKmh));
                        break;
                    case "typ":
                        val.typVal = GLScript.typVal.str;
                        if (currInfoPlayer.viewSPBSplit == "P")
							val.sval = utils.quote("PB");
                        else if (currInfoPlayer.viewSPBSplit == "S")
							val.sval = utils.quote("Sess");
                        else if (currInfoPlayer.viewSPBSplit == "W")
							val.sval = utils.quote("WR");
                        else
							val.sval = utils.quote("typ");
                        break;
                    case "dist":
                        {
                            val.typVal = GLScript.typVal.str;
                            double len = utils.getLenTrack(currState.ShortTrackName);
//                            double len = trackInfo.getLen(currState.ShortTrackName);
                            int dist = (int)(len * (double)currInfoPlayer.gripDriverLapInfo.laps);
                            //                            val.sval = quote(unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)dist).ToString("0") + " " + getUnitDist(currInfoPlayer.unitSpeedKmh));
							val.sval = utils.quote(dist.ToString("0"));
                        }
                        break;
                    case "sessdist":
                        {
                            val.typVal = GLScript.typVal.str;
                            double len = utils.getLenTrack(currState.ShortTrackName);
//                            double len = trackInfo.getLen(currState.ShortTrackName);
                            int sess_dist = (int)(len * (double)currInfoPlayer.sessLaps);
                            //                            val.sval = quote(unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)sess_dist).ToString("0") + " " + getUnitDist(currInfoPlayer.unitSpeedKmh));
							val.sval = utils.quote(sess_dist.ToString("0"));
                        }
                        break;
                    case "unamebehind":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
							val.sval = utils.quote(currInfoPlayer.UNameBehind);
                        else
							val.sval = utils.quote("");
                        break;

                    case "gapbehind":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
							val.sval = utils.quote(currInfoPlayer.gapBehind);
                        else
							val.sval = utils.quote("");
                        break;
                    case "unamebefore":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
							val.sval = utils.quote(currInfoPlayer.UNameBefore);
                        else
							val.sval = utils.quote("");
                        break;
                    case "gapbefore":
                        val.typVal = GLScript.typVal.str;
                        if (currRace.inRace)
							val.sval = utils.quote(currInfoPlayer.gapBefore);
                        else
							val.sval = utils.quote("");
                        break;
                    case "oldtyrerearleft":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreRearLeft));
                        break;
                    case "oldtyrerearright":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreRearRight));
                        break;
                    case "oldtyrefrontleft":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreFrontLeft));
                        break;
                    case "oldtyrefrontright":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.oldTyreFrontRight));
                        break;
                    case "tyrerearleft":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreRearLeft));
                        break;
                    case "tyrerearright":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreRearRight));
                        break;
                    case "tyrefrontleft":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreFrontLeft));
                        break;
                    case "tyrefrontright":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(Enum.GetName(typeof(InSim.tyre), currInfoPlayer.tyreFrontRight));
                        break;
                    case "authlevel":
                        val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(StringLevelsAllowedPlayer(currInfoPlayer, true));
                        break;
                    // Numeric return
                    case "penaltynew":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.PenaltyNew;
                        break;
                    case "numcarresets":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.NumCarResets;
                        break;
                    case "laps":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.gripDriverLapInfo.laps;
                        break;
                    case "pos":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.currPos;
                        break;
                    case "sesslaps":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sessLaps;
                        break;
                    case "totalpittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.totalPitTime;
                        break;
                    case "pittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.pitTime;
                        break;
                    case "pitstops":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.pitStops;
                        break;
                    case "swearwordsrem":
                        val.typVal = GLScript.typVal.num;
                        val.fval = newCfg.varsLapper.SwearWordsMax - currInfoPlayer.swearWordsCount;
                        break;
                    case "lapsdone":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lapsDone;
                        break;
                    case "p_mass": // Player Current Mass
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.P_Mass;
                        break;
                    case "p_tres": // Player CUrrent Restriction
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.P_TRes;
                        break;
                    case "h_mass": // Player required Mass
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.H_Mass;
                        break;
                    case "h_tres": // Player Required restriction
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.H_TRes;
                        break;
                    case "split1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[0];
                        break;
                    case "split2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[1];
                        break;
                    case "split3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.split[2];
                        break;
                    case "laptime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lapTime;
                        break;
					case "pblaptime":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.gripDriverLapInfo.personalBestLapTime;
						break;
					case "pbdrift":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.driftDriverLapInfo.driftPoints;
						break;
					case "difflaptimetopb":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffLapTimeToPb;
                        break;
                    case "splittime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lastSplitTime;
                        break;
					case "wr":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.wr;
						break;
					case "psdistance":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSDistance;
						break;
					case "psfuel":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSFuel;
						break;
					case "pslaps":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSLaps;
						break;
					case "pshostsjoined":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSHostsJoined;
						break;
					case "pswins":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSWins;
						break;
					case "pssecond":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSSecond;
						break;
					case "psthird":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSThird;
						break;
					case "psfinished":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSFinished;
						break;
					case "psquals":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSQuals;
						break;
					case "pspole":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSPole;
						break;
					case "psdrags":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSDrags;
						break;
					case "psdragwins":
						val.typVal = GLScript.typVal.num;
						val.fval = currInfoPlayer.PSDragWins;
						break;
					case "pscountry":
						val.typVal = GLScript.typVal.str;
						val.sval = utils.quote( currInfoPlayer.PSCountry );
						break;
					case "sector":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.currSector;
                        break;
					case "lastsector":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.lastSector;
                        break;
					case "sectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[0];
                        break;
                    case "sectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[1];
                        break;
                    case "sectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplit[2];
                        break;
                    case "sectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.sectorSplitLast;
                        break;
                    case "bestsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[0];
                        break;
                    case "bestsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[1];
                        break;
                    case "bestsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplit[2];
                        break;
                    case "bestsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.bestSectorSplitLast;
                        break;
                    case "diffsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[0];
                        break;
                    case "diffsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[1];
                        break;
                    case "diffsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplit[2];
                        break;
                    case "diffsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.diffSectorSplitLast;
                        break;
                    case "isbestsectorsplit1":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[0])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplit2":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[1])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplit3":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplit[2])
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "isbestsectorsplitlast":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.isBestSectorSplitLast)
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "avgspeed":
                        val.typVal = GLScript.typVal.num;
                        //val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, trackInfo.getAvgSpeed(currState.ShortTrackName, currInfoPlayer.lapTime))));
                        val.fval = float.Parse(string.Format("{0:n}", trackInfo.getAvgSpeed(currState.ShortTrackName, currInfoPlayer.lapTime)));
                        break;
                    case "instantspeed":
                        val.typVal = GLScript.typVal.num;
                        //                        val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.instantSpeed)));
                        val.fval = float.Parse(string.Format("{0:n}", currInfoPlayer.instantSpeed));
                        break;
                    case "bestspeed":
                        val.typVal = GLScript.typVal.num;
                        //                        val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.instantSpeed)));
                        val.fval = float.Parse(string.Format("{0:n}", currInfoPlayer.bestSpeed));
                        break;
                    case "tpb":
                        val.typVal = GLScript.typVal.num;
                        val.fval = currInfoPlayer.TPb;
                        break;
                    case "driftscore":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.totaldriftscore.ToString("F0"));
                        break;
                    case "anglevelocity":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.AngVel.ToString("F0"));
                        break;
                    case "lastdriftscore":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.lastdriftscore.ToString("F0"));
                        break;
                    //Acceleration
                    case "accelerationstartspeed":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeed.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeedMph.ToString("F0"));
                        break;
                    case "accelerationendspeed":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeed.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeedMph.ToString("F0"));
                        break;
                    //Acceleration
                    //Acceleration2
                    case "accelerationstartspeed2":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeed2.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationStartSpeedMph2.ToString("F0"));
                        break;
                    case "accelerationendspeed2":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.unitSpeedKmh)
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeed2.ToString("F0"));
                        else
                            val.fval = float.Parse(newCfg.varsLapper.AccelerationEndSpeedMph2.ToString("F0"));
                        break;
                    case "accelerationtime2":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.accelerationTime2.TotalSeconds.ToString("F1"));
                        break;
                    //Acceleration2
                    case "accelerationtime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = float.Parse(currInfoPlayer.accelerationTime.TotalSeconds.ToString("F1"));
                        break;
                    case "maxallowedlaptime1":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime1 / 100) * ((double)currInfoPlayer.MaxLapTime));
                        break;
                    case "maxallowedlaptime2":
                        val.typVal = GLScript.typVal.num;
                        if (newCfg.varsLapper.MaxAllowedLapTime2 != 1)
                            val.fval = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime2 / 100) * ((double)currInfoPlayer.MaxLapTime));
                        else
                            val.fval = -1;
                        break;
                    case "remainfdip":
                        val.typVal = GLScript.typVal.num;
                        if (newCfg.varsLapper.MaxFastDriveOnPit != 99999)
                            val.fval = newCfg.varsLapper.MaxFastDriveOnPit - currInfoPlayer.NbFastDriveOnPit;
                        else
                            val.fval = -1;
                        break;
                    case "finishedpos":
                        val.typVal = GLScript.typVal.num;
//                        if (currInfoPlayer.finishedPos != -1)
//                        {
                            val.fval = (float)currInfoPlayer.finishedPos;
//                        }
                        break;
                    case "racetotaltime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.raceTotalTime;
                        break;
                    case "racepbtime":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.racePBTime;
                        break;
                    case "currnode":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.CurrNode;
                        break;
                    case "ontrack":
                        val.typVal = GLScript.typVal.num;
                        if (currInfoPlayer.OnTrack)
                            val.fval = 1;
                        else
                            val.fval = 0;
                        break;
                    case "x":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.x;
                        break;
					case "y":
						val.typVal = GLScript.typVal.num;
						val.fval = (float)currInfoPlayer.y;
						break;
                    case "z":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.z;
                        break;
                    case "idzone":
						val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.idCurrZone);
						break;
					case "totdistmeter":
						val.typVal = GLScript.typVal.num;
						val.fval = (float)currInfoPlayer.totDistMeter;
						break;
					case "viewspbsplit":
						val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.viewSPBSplit.ToString()); ;
						break;
					case "showsplitpb":
						val.typVal = GLScript.typVal.num;
						if (currInfoPlayer.showSplitPB)
							val.fval = 1;
						else
							val.fval = 0;
						break;
					case "ucid":
						val.typVal = GLScript.typVal.num;
						val.fval = (float)currInfoPlayer.UCID;
						break;
					case "plid":
						val.typVal = GLScript.typVal.num;
						val.fval = (float)currInfoPlayer.PLID;
						break;
					case "unitspeedkmh":
						val.typVal = GLScript.typVal.num;
						if( currInfoPlayer.unitSpeedKmh )
							val.fval = 1;
						else
							val.fval = 0;
						break;
					case "idlang":
						val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.idLang);
						break;
					case "ishost":
						val.typVal = GLScript.typVal.num;
						if( currInfoPlayer.isHost )
							val.fval = 1;
						else
							val.fval = 0;
						break;
					case "numberplate":
						val.typVal = GLScript.typVal.str;
						val.sval = utils.quote(currInfoPlayer.Plate);
						break;
                    //Object contact Player Vars
                    case "objectcontactspeed":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)(currInfoPlayer.ObjectContactSpeed * 3.6);
                        break;
                    case "objectcontactdir":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)(currInfoPlayer.ObjectContactDir);
                        break;
                    case "objectcontacthead":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)(currInfoPlayer.ObjectContactHead);
                        break;
                    case "heading":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)(currInfoPlayer.heading);
                        break;
                    case "direction":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)(currInfoPlayer.direction);
                        break;

                    //Streetcode Yisc[NL]
                    case "currstreet":
                        val.typVal = GLScript.typVal.num;
                        val.fval = (float)currInfoPlayer.CurrStreet;
                        break;
                    case "idcurrstreet":
                        val.typVal = GLScript.typVal.str;
                        val.sval = utils.quote(currInfoPlayer.idCurrStreet);
                        break;
                    default: // Normally, go never here
                        GLScript.unionVal retVal = currInfoPlayer.playerVars.Get(idVar);
                        val.typVal = retVal.typVal;
                        val.sval = retVal.sval;
                        val.fval = retVal.fval;
                        break;

                }
            }
            #endregion

        }

    }
}